#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** Compare Filters *******

Function Compare2FiltersReset()
	CompareFiltersUpdate(1)
End

Proc Compare2Filters(ctrlName) : ButtonControl
	String ctrlName
	
	DoWindow/F WMCompareFilters
	if( V_Flag==1 )
		return 0
	endif
	GuaranteeIFDLInitialized()
	KillAllFilterDesignWindows()
	SetApplyButtonTitle(1)
	Variable fs= NumVarOrDefault("root:Packages:WM_IFDL:fs",1)

	String dfSav= Set_IFDL_DataFolder()
	// Create the globals
	// storage to detect change in selected filters
	String/G c_filter1="", c_filter2=""
	SetDataFolder dfSav

	CompareFiltersUpdate(0)
	CreateWMCompareFilters()
	CompareFiltersUpdate(0)			// set the control limits, too.
End

// updates the other Compare 2 filters parameters, whenever any parameter changes
// AND (unlike design windows) recomputes filtered responses, updates traces, etc.
Function CompareFiltersUpdate(forceFilterChange)
	Variable forceFilterChange
	NVAR fs= root:Packages:WM_IFDL:fs
	DoWindow WMCompareFilters
	if( V_Flag == 0 ) 
		return 0
	endif

	// make changes if the DB checkbox doesn't agree with which waves are displayed...
	Variable wantDB=  dBIsChecked("WMCompareFilters")
		
	CheckDisplayed/W=WMCompareFilters root:Packages:WM_IFDL:filter1DbMag, root:Packages:WM_IFDL:filter2DbMag
	Variable dBRequiresChange=wantDB %^ (V_Flag != 0)

	Variable needLegend= 0					// update if we change any traces
	// Update the response (and details) whenever any of the filter selections changes
	SVAR c_filter1=root:Packages:WM_IFDL:c_filter1
	ControlInfo/W=WMCompareFilters filt1
	Variable filter1Changed= CmpStr(c_filter1,S_Value) != 0
	if( dBRequiresChange %| filter1Changed %| forceFilterChange)
		c_filter1= S_Value
		CompareFiltersResponse(1,c_filter1,wantDB)	// compute filter 1 response and append it (or remove it)
		needLegend= 1
	endif

	SVAR c_filter2=root:Packages:WM_IFDL:c_filter2
	ControlInfo/W=WMCompareFilters filt2
	Variable filter2Changed= CmpStr(c_filter2,S_Value) != 0
	if( dBRequiresChange %| filter2Changed %| forceFilterChange )	// filter 2 changed!
		c_filter2= S_Value
		CompareFiltersResponse(0,c_filter2,wantDB)	// compute filter 2 response and append it
		needLegend= 1
	endif

	if(filter1Changed  %| filter2Changed  %| forceFilterChange)
		AutoApplyFilter()
	endif
	if( needLegend )
		compareLegend()		// brings the compare window back up.
	endif
	DoWindow/F WMCompareFilters
End

Function/S CompareFilterName(isFilter1,wantPath)
	Variable isFilter1,wantPath
	
	String filterName=""
	if( wantPath )
		filterName+="root:Packages:WM_IFDL:"
	endif
	if( isFilter1 )
		filterName+="filter1"
	else
		filterName+="filter2"
	endif
	return filterName
End

// returns actual name of filter, not the proxy in the IFDL data folder
Function/S CompareFilter(filterNumber)
	Variable filterNumber // 1 or 2
	
	if( filterNumber == 1 )
		SVAR filterName= root:Packages:WM_IFDL:c_filter1
	else
		SVAR filterName= root:Packages:WM_IFDL:c_filter2
	endif
	return filterName
End

// CompareFiltersResponse() returns truth that
// the response was newly appended to the graph
Function CompareFiltersResponse(isFilter1,newCoefsName, wantDB)
	Variable isFilter1, wantDB
	String newCoefsName
	
	Variable wrongTraceIsAppended,appended= 0
	String tracePath= CompareFilterName(isFilter1,1)+"Mag"			// see FreqMagnitude()
	String tracePathDB= CompareFilterName(isFilter1,1)+"DbMag"	// see FreqMagnitude()

	CheckDisplayed/W=WMCompareFilters $tracePath,$tracePathDB
	if( wantDB )
		wrongTraceIsAppended= V_Flag %& 0x1	// want DB, but "Mag" is appended
	else
		wrongTraceIsAppended= V_Flag %& 0x2	// want linear, but "DbMag" is appended
	endif
	Variable removeTraces= (CmpStr(newCoefsName,"_none_") == 0) %| (wrongTraceIsAppended)
	
	if( removeTraces )
		CheckDisplayed/W=WMCompareFilters $tracePath, $tracePathDB
		if( V_Flag != 0 )
			DoWindow/F WMCompareFilters
			String t1= CompareFilterName(isFilter1,0)+"Mag"
			String t2= CompareFilterName(isFilter1,0)+"DbMag"
			RemoveFromGraph/Z $t1, $t2
		endif
	endif
	if ( CmpStr(newCoefsName,"_none_") != 0 )
		FixFilterDelay($newCoefsName)
		String filterPath= CompareFilterName(isFilter1,1)
		Duplicate/O $newCoefsName, $filterPath
		Wave filt= $filterPath
		String responsePath= FreqMagnitude(filt,wantDB,0)	// don't apply Hanning window to filter, it completely changes it!
		Wave response= $responsePath
		appended= CompareFiltersAppendResponse(isFilter1,response,wantDB)
	endif
	return appended
End

Function CompareCheck(ctrlName,checked)
	String ctrlName
	Variable checked
	
	CompareFiltersUpdate(0)
End

// Put response on the responseLeft and bottom axes (if not already in graph)
//
Function CompareFiltersAppendResponse(isFilter1,response, wantDB)
	Variable isFilter1
	Wave response
	Variable wantDB
	
	CheckDisplayed/W=WMCompareFilters response
	if( V_Flag == 1 )
		return 0
	endif
	DoWindow/F WMCompareFilters
	if( V_Flag == 0 )
		return 0
	endif
	
	Variable responseLeftExisted = strlen(AxisInfo("","responseLeft")) > 0
	Variable bottomExisted = strlen(AxisInfo("","bottom")) > 0

	AppendToGraph/L=responseLeft/B response
	String traceName= NameOfWave(response)	// presumably #0
	if( !isFilter1 )
		ModifyGraph rgb($traceName)=(0,0,65535)
	endif
	if( !responseLeftExisted )
		ModifyGraph lblPos(responseLeft)=60
		ModifyGraph freePos(responseLeft)={0,bottom}
		ModifyGraph margin(left)=67
		SetAxis/A/N=1 responseLeft
	endif
	if( wantDB )
		Label responseLeft "response (dB)"
	else
		Label responseLeft "response"
	endif

	if( !bottomExisted )
		ModifyGraph minor(bottom)=1
	endif
	String annotations= AnnotationList("")
	if( FindItemInList("compareLegend", annotations, ";", 0) < 0 ) // annotation not appended, yet
		Textbox/C/N=compareLegend/X=0.99/Y=34.30 ""	// set initial position
	endif
	return 1	// truth the trace was newly appended
End

Function CreateWMCompareFilters()

	DesignGraph("WMCompareFilters","Compare 2 Filters")

	NVAR fs= root:Packages:WM_IFDL:fs
	String dfSav= Set_IFDL_DataFolder()
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls
	SetDataFolder dfSav
	
	Variable popIndex= 1	// _none_
	String popVal= "_none_"
	if( exists("coefs") == 1 )
		popIndex += 1		// "coefs"
		popVal= "coefs"
	endif

	ModifyGraph margin(left)=67
	ControlBar 46
	PopupMenu filt1,pos={7,3},size={118,19},proc=WMComparePopup,title="Filter 1:"
	PopupMenu filt1,mode=popIndex,popvalue=popVal,value= #"\"_none_;\"+ListFilterlikeWaves()"
	PopupMenu filt2,pos={7,24},size={186,19},proc=WMComparePopup,title="Filter 2:"
	PopupMenu filt2,mode=1,popvalue="_none_",value= #"\"_none_;\"+ListFilterlikeWaves()"
	CheckBox dbCheck,pos={276,27},size={110,15},proc=CompareCheck,title="dB Response",value=1
	SetWindow kwTopWin,hook=designHook
End

Function compareLegend()

	DoWindow/F WMCompareFilters
	String annotations= AnnotationList("")
	if( FindItemInList("compareLegend", annotations, ";", 0) < 0 ) // annotation not appended, yet
		return 1
	endif
	SVAR c_filter1= root:Packages:WM_IFDL:c_filter1
	String str= DesignLegendPiece("filter1Mag",c_filter1)
	str += DesignLegendPiece("filter1DbMag",c_filter1)
	SVAR c_filter2= root:Packages:WM_IFDL:c_filter2
	str+= DesignLegendPiece("filter2Mag",c_filter2)
	str+= DesignLegendPiece("filter2DbMag",c_filter2)
	Legend/C/N=compareLegend RemoveLastChar(str)
	return 0
End

Function WMComparePopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr

	CompareFiltersUpdate(0)
End
